[//lasso
	/*
	============================================================================
	Simple Web 2.0 with Lasso and jQuery - Weather Module
	============================================================================
	Author: Jason Huck/Core Five Creative
	Lasso Summit 2007
	----------------------------------------------------------------------------
	
	This module displays current weather conditions for the supplied zip code
	and updates itself every 15 minutes. The user can change the zip code. Data
	is supplied by WeatherBug. Zip code is stored in a session.
	*/

	// NOTE: WeatherBug API Key is registered for Lasso Summit 2007.
	var('wbKey' = 'A6679098776');

	// start/refresh user session with 'zip' var
	session_start( -name='jquerydemo', -expires=(60 * 24 * 365));
	session_addvar('wbZip', -name='jquerydemo');

	// include map of condition codes to conditions and graphics
	library('lib/modules/weathermap.inc');

	// zip will be user supplied, but default to 33301 for the summit
	!var_defined('wbZip') ? var('wbZip' = '33301');

	// define tag to get weather data and format the output for our specific layout
	// see http://tagswap.net/index.lasso?pgID=2&kwd=weatherbug for tag usage
	define_tag(
		'weatherdata',
		-req='key',
		-req='zip',
		-priority='replace'
	);
		protect;
			// get station id
			local('wbStation') = weatherbug_getstations(
				-key=#key,
				-zip=#zip
			)->first->find('id');

			// must retrieve 2-day forecast to get current condition code
			local('wbConditionCode' = 10);

			local('wb2DayForecast') = string(
				include_url(
					'http://' + #key + '.isapi.wxbug.net/forecastISAPI/ForecastISAPI.dll',
					-getparams=array(
						'Magic' = '10992',
						'RegNum' = '0',
						'ZipCode' = #zip,
						'StationID' = #wbStation,
						'Version' = '7',
						'Units' = '0',
						't' = '987689856'
					)
				)
			);

			#wbConditionCode = integer(#wb2DayForecast->split('|')->get(5));

			// look up current condition code
			local('wbCondData') = @$wbConditions->find(#wbConditionCode)->first->second;
			local(
				'wbCondition' = @#wbCondData->get(1),
				'wbCondIcon' = @#wbCondData->get(2)
			);

			local('wbFull') = weatherbug_getliveweather(
				-key=#key,
				-zip=#zip,
				-station=#wbStation
			);

			local('wbCurrent') = map(
				'temp' = integer(#wbFull->find('temp')->find('value')),
				'feelslike' = @#wbFull->find('feels-like')->find('value'),
				'winddir' = @#wbFull->find('wind-direction')->find('value'),
				'windspeed' = @#wbFull->find('wind-speed')->find('value'),
				'humidity' = @#wbFull->find('humidity')->find('value'),
				'pressure' = @#wbFull->find('pressure')->find('value'),
				'pressuredir' = (integer(#wbFull->find('pressure-rate')->find('value')) < 0 ? 'F' | 'R')
			);

			local('out' = '
					<div id="weathercontainer">
						<div class="current">
							<img src="lib/images/weather/' + #wbCondIcon + '" width="32" height="32" /><br />
							' + #wbCondition + '
						</div>
						<div id="temp">' + #wbCurrent->find('temp') + '&deg;F</div>
						<div class="current">
							Feels Like ' + #wbCurrent->find('feelslike') + '&deg;F<br />
							<a href="http://www.weather.com/weather/tenday/' + #zip + '" target="_blank">Check Forecast</a>
						</div>
					</div>
					<div id="forecast">
						Wind: <strong>From ' + #wbCurrent->find('winddir') + ' at ' + #wbCurrent->find('windspeed') + ' mph</strong><br />
						Humidity: <strong>' + #wbCurrent->find('humidity') + '%</strong><br />
						Pressure: <strong>' + #wbCurrent->find('pressure') + ' in. ' + #wbCurrent->find('pressuredir') + '</strong><br />
					</div>
			');

			handle_error;
				local('out' = '
					<div id="weathercontainer">
						An error prevented weather data from being displayed.
					</div>
				');
				
				error_reset;
     		/handle_error;
		/protect;

		return(@#out);
	/define_tag;

	// ajax functions
	if(request_isajax);
		// set the new zip if supplied
		action_param('zip') ? $wbZip = action_param('zip');
		// generate new output
		content_body = weatherdata( -key=$wbKey, -zip=$wbZip);
		abort;
	/if;
]
<script type="text/javascript">
$(function(){
	// function to handle changing the zip code
	changeZip = function() {
		// get the current value from the "weatherzip" element
		var currentZip = $('#weatherzip').html();
		// display a javascript prompt to see if the user wants to change it
		var newZip = prompt('Please enter a new zip code to use:', currentZip);
		// if so...
		if(newZip){
			// hide the "change location" link
			$('#weatherlocationswitch').css('visibility','hidden');
			// fade out the existing weather data
			$('#weatherconditions').fadeOut('slow',function(){
				// replace the contents of "weatherconditions" with new data
				$(this).load('./?mode=weather&function=change&zip=' + newZip, function(){
					// ...and fade it back in
					$(this).fadeIn('slow', function(){
						// now we can show the "change location" link again
						$('#weatherlocationswitch').css('visibility','visible');
					});
				});
			});

			// update the "weather" header
			$('#weather').html('Weather For: <span id="weatherzip">' + newZip + '</span>');
			// re-round the corner for fancy-schmancy web 2.0 look :P
			$('#weather').corner('round tr 10px');
		}
	}

	// set a timer to refresh every 15 minutes
	var weathertimer = setInterval(function(){
		$('#weatherconditions').load('./?mode=weather&function=refresh');
	}, 900000);

	// bind a click event to change the zip
	$('#weatherlocationswitch').click(function(){
		changeZip();
		return false;
	});

	// run the refresh function on initial page load
	$('#weatherconditions').load('./?mode=weather&function=refresh');
});
</script>

<h2 class="modtitle grey" id="weather">Weather For: <span id="weatherzip">[$wbZip]</span></h2>
<div id="weatherbox" class="mod lightgrey">
	<div id="weatherconditions">
	</div>
	<div id="weathercredits">
		<a id="weatherlocationswitch" href="#">Change Location</a>
	</div>
</div>
